
/*++
Copyright (c) 2014 Intel Corporation. All rights reserved
This software and associated documentation (if any) is furnished
under a license and may only be used or copied in accordance
with the terms of the license. Except as permitted by such
license, no part of this software or documentation may be
reproduced, stored in a retrieval system, or transmitted in any
form or by any means without the express written consent of
Intel Corporation.
Module Name:

FwUpdLclApp.c

Abstract:

FW Update Local Sample Code demonstrating usage of FW Update Library

--*/

//#include "stdafx.h"
#include "typedef.h"
#include "Fwu_Common.h"
#include "cse_basic_types.h"
#include "Common.h"
#include "me_status.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <iostream>
#include "FWUpdateLib.h"


/*extern "C" {
#include "FWUpdateLib.h"
}*/

//UINT32             g_fwuError = 0

#define MAXIMUM_IPU_SUPPORTED          4
#define CMD_LINE_STATUS_UPDATE_1        0
#define CMD_LINE_STATUS_UPDATE_2        1
#define CMD_LINE_STATUS_UPDATE_3        2
#define CMD_LINE_STATUS_UPDATE_4        3

// Info Strings 
#define ID_INFO_DOT     "."
#define ID_INFO_2       "\nTrying to receive update status..."
#define ID_INFO_3       "Communication Mode: MEI\n"
#define ID_INFO_16      "Maximum Retry limit reached. Please reboot to try again\n"

// Error Strings 
#define ID_ERROR_2      "\nError %d: Firmware update not initiated due to invalid hostname specified\n"
#define ID_ERROR_3      "\nError %d: Firmware update tool failed due to insufficient memory\n"
#define ID_ERROR_4      "\nError %d: Update operation timed-out; cannot determine if the operation succeeded\n"
#define ID_ERROR_5      "\nError %d: Cannot receive the current version from the firmware after update\n"
#define ID_ERROR_6      "\nError %d: Update finished but version mismatch after the update\n"
#define ID_ERROR_7      "\nError %d: Firmware update not initiated due to an invalid FW image \n"
#define ID_ERROR_8      "\nError %d: Firmware update not initiated due to integrity failure or invalid FW image"
#define ID_ERROR_9      "\nError %d: Firmware update operation not initiated due to a SKU mismatch\n"
#define ID_ERROR_10     "\nError %d: Firmware update not initiated due to version mismatch\n"
#define ID_ERROR_11     "\nError %d: Firmware update failed due to authentication failure\n"
#define ID_ERROR_12     "\nError %d: Firmware update failed due to insufficient memory\n"
#define ID_ERROR_13     "\nError %d: Firmware update iAMT communication failed, Failed to find certificate '%s' in certificate store\n"
#define ID_ERROR_14     "\nError %d: Firmware update iAMT communication failed, Failed to set HTTP certificate options (%d): %s\n"
#define ID_ERROR_15     "\nError %d: Firmware update iAMT communication failed, Failed to find certificate names\n"
#define ID_ERROR_16     "\nError %d: Firmware update iAMT communication failed, Failed to open system certificate store (%d): %s\n"
#define ID_ERROR_17     "\nError %d: Firmware update tool failed to connect iAMT through LMS, due to a HTTP operation failure,\nPlease verify the inputs (host, user, password, certificate, work mode etc).\n"

#define ID_ERROR_18     "\nError %d: Invalid usage\n"
#define ID_ERROR_18B    "\nError %d: Invalid usage, -allowsv switch required to update the same version firmware\n"
#define ID_ERROR_19     "\nError %d: Failed to receive last update status from the firmware\n"
#define ID_ERROR_20     "\nError %d: Firmware Update operation not initiated because a firmware update is already in progress\n"
#define ID_ERROR_21     "\nError %d: Invalid UUID provided with the OEMID switch\n"
#define ID_ERROR_22     "\nError %d: OEM ID verification failed.\n"
#define ID_ERROR_24     "\nError %d: Firmware update tool failed to get the firmware parameters\n"

#define ID_ERROR_25     "\nError %d: Firmware update failed due to an internal error\n"
#define ID_ERROR_25A    "\nError %d: Firmware update failed due to an internal error\nFirmware returns SAL notification error, Please try after ME-reset or re-flashing the ME image.\n"
#define ID_ERROR_25B    "\nError %d: Firmware update failed due to an internal error\nFirmware returns Audit policy error, Please try after ME-reset or re-flashing the ME image.\n"
#define ID_ERROR_25C    "\nError %d: Firmware update failed due to an internal error\nFirmware failed to create fault tolerant partition, Please try after ME-reset or re-flashing the ME image.\n"
#define ID_ERROR_25D    "\nError %d: Firmware update failed due to an internal error\nFirmware failed  on image version history check.\n"
#define ID_ERROR_25E    "\nError %d: Firmware update failed due to an internal error\nFirmware failed with write file issue.\n"
#define ID_ERROR_25F    "\nError %d: Firmware update failed due to an internal error\nFirmware failed with read file issue.\n"
#define ID_ERROR_25G    "\nError %d: Firmware update failed due to an internal error\nFirmware failed with delete file issue.\n"
#define ID_ERROR_25H    "\nError %d: Firmware update failed due to an internal error\nFirmware returns invalid flash code partition.\n"
#define ID_ERROR_25I    "\nError %d: Firmware update failed due to an internal error\nFirmware returns invalid flash NFT partition.\n"
#define ID_ERROR_25J    "\nError %d: Firmware update failed due to an internal error\nFirmware returns invalid image length.\n"
#define ID_ERROR_25K    "\nError %d: Firmware update failed due to an internal error\nFirmware returns invalid GLUT.\n"
#define ID_ERROR_25L    "\nError %d: Firmware update failed due to an internal error\nFirmware Update client is not ready to perform an update.\n"

#define ID_ERROR_26     "\nError %d: Unsupported Operating System\n"
#define ID_ERROR_27     "\nError %d: No Firmware update is happening\n"
#define ID_ERROR_28     "\nError %d: Unknown or Unsupported Platform\n"
#define ID_ERROR_29     "\nError %d: Firmware update cannot be initiated because Local Firmware update is disabled\n"
#define ID_ERROR_30     "\nError %d: Firmware update cannot be initiated because Secure FW update is disabled\n"
#define ID_ERROR_31     "\nError %d: Firmware update not initiated due to an invalid FW image header\n"
#define ID_ERROR_32     "\nError %d: Firmware update not initiated due to file [%s] open or read failure\n"
#define ID_ERROR_33     "\nError %d: Firmware update cannot be initiated because the OEM ID provided is incorrect\n"
#define ID_ERROR_34     "\nError %d: Firmware update not initiated due to file open or read failure\n"
#define ID_ERROR_35     "\nError %d: Firmware update iAMT communication failed, HTTP request failed: Certificate rejected\n"
#define ID_ERROR_36     "\nError %d: This version of the Intel (R) FW Update Tool is not compatible with the current platform.\n"
#define ID_ERROR_37     "\nError %d: Intel (R) ME Interface : Cannot locate ME device driver\n"
#define ID_ERROR_38     "\nError %d: Platform did not respond to update request.\n"
#define ID_ERROR_39     "\nError %d: Intel (R) ME Interface : Unsupported message type\n"
#define ID_ERROR_40     "\nError %d: Firmware update not initiated due to invalid image length\n"
#define ID_ERROR_41     "\nError %d: Firmware update not initiated due to an unavailable global buffer\n"
#define ID_ERROR_44     "\nError %d: Firmware update not initiated due to invalid firmware parameters\n"
#define ID_ERROR_46     "\nError %d: Firmware update iAMT communication failed, WSMAN not supported\n"
#define ID_ERROR_51     "\nError %d: PLEASE REBOOT YOUR SYSTEM. Firmware update cannot be initiated without a reboot.\n"
#define ID_ERROR_52     "\nError %d: An internal error to the AMT device has occurred.\n"
#define ID_ERROR_53     "\nError %d: AMT Status is not ready.\n"
#define ID_ERROR_54     "\nError %d: Invalid AMT Mode.\n"
#define ID_ERROR_55     "\nError %d: Encountered error writing to file.\n"
#define ID_ERROR_56     "\nError %d: Display FW Version failed.\n"
#define ID_ERROR_57     "\nError %d: The image provided is not supported by the platform.\n"
#define ID_ERROR_57A    "\nError %d: This platform does not allow downgrade/upgrade with the file provided.\n"
#define ID_ERROR_58     "\nError %d: Internal Error.\n"
#define ID_ERROR_59     "\nError %d: Update downgrade vetoed.\n"
#define ID_ERROR_60     "\nError %d: Firmware write file failure.\n"
#define ID_ERROR_61     "\nError %d: Firmware read file failure.\n"
#define ID_ERROR_62     "\nError %d: Firmware delete file failure.\n"
#define ID_ERROR_63     "\nError %d: Partition layout NOT compatible.\n"
#define ID_ERROR_64     "\nError %d: Downgrade NOT allowed, data mismatched.\n"
#define ID_ERROR_65     "\nError %d: Password did not match.\n"
#define ID_ERROR_66     "\nError %d: Password exceeded maximum number of retries.\n"
#define ID_ERROR_67     "\nError %d: Password Not provided when required.\n"
#define ID_ERROR_68     "\nError %d: Polling for FW Update Failed.\n"
#define ID_ERROR_69     "\nError %d: FW Update Failed.\n"
#define ID_ERROR_70     "\nError %d: Intel (R) ME Interface : Cannot locate ME device driver; unable to determine if the operation succeeded.\n"
#define ID_ERROR_71     "\nError %d: Intel (R) ME Interface : Lost communication with platform during update; unable to determine if the update completed.\n"
#define ID_ERROR_72     "\nError %d: Unable to read FW version from file. Please verify the update image used.\n"
#define ID_ERROR_73     "\nError %d: Firmware is in recovery mode. Please update only using the previously attempted version.\n"

//
// Specify the OEM ID to be passed to the ME
// The bit order must match what was created with FITC.
//
// For example:
// FITC Setting: 00000000-0001-0000-0000-00000000001
// MEINFO.EXE returns: 00000000-0001-0000-0000-00000000001
// 
// mOemId would be: 
  _UUID                      mOemId = {0x00000000, 0x0001, 0x0000, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};
//
//_UUID                      mOemId = {0x68853622, 0xeed3, 0x4e83, 0x8a, 0x86, 0x6c, 0xde, 0x32, 0x00, 0x00, 0x00};
//_UUID                      mOemId = {0x68853622, 0xEED3, 0x4E83, 0x8A, 0x86, 0x6C, 0xDE, 0x31, 0x5F, 0x6B, 0x78};

//Defines
// Last Reset Types
/*#define NORESET 0
#define HOSTRESET  1
#define MERESET  2
#define GLOBALRESET 3*/

#define MFT_PART_INFO_EXT_UPDATE_ACTION_NONE         0
#define MFT_PART_INFO_EXT_UPDATE_ACTION_HOST_RESET   1
#define MFT_PART_INFO_EXT_UPDATE_ACTION_CSE_RESET    2
#define MFT_PART_INFO_EXT_UPDATE_ACTION_GLOBAL_RESET 3

// Get Interface
#define FW_UPDATE_DISABLED 0
#define FW_UPDATE_ENABLED 1
#define FW_UPDATE_PASSWORD_PROTECTED 2

//
//
//  MSFT compiler uses this variable to inform itself whether floating
//  point support is loaded.
//
/*
int _fltused;

unsigned int      index = 0;
signed int        timer30s = 0;

FlashVersion  mVersion;
*/
/*
//
// Print a message to the desired output device
// Customize for platform
//
void DisplayConsoleMessage (
IN CHAR16 *String
)
{
Print(String);
}
*/
char* ImageBuffer = NULL;
int PerformUpdate(char* ImageBuffer);
int CheckFileExt(char *file);

int CheckFileExt(char *file)
{
    INT32 len = 0;
    char* begin = NULL;
    char* end = NULL;

    if(NULL == file)
    {
        return 1;
    }

    len = (int)strlen(file);
    end = file + len - 1;

    while(*end != '.' && end != file)
    {
        end--;
    }

    begin = end+1;

    printf("File Extension: %s\n",begin);


    if(!stricmp(begin,"bin"))
    {
        return 1;
    }

    return 0;
}

void DisplaySendStatus(float BytesSent, float BytestobeSent)
{
    float   value = (BytesSent / BytestobeSent) * 100;
    UINT32  pValue = (UINT32)value;

    if (pValue != 100) {
        printf ("Sending the update image to FW for verification:  [ %d%% ]\r", pValue);
    }	else {
        printf ("Sending the update image to FW for verification:  [ COMPLETE ] \n");
    }
}


void DisplayTextForReturnErrorCode(UINT32 Code)
{
    switch(Code) {
    case FWU_NO_MEMORY:
        printf (ID_ERROR_3, FWU_NO_MEMORY);
        break;
    case FWU_UPDATE_TIMEOUT:
        printf (ID_ERROR_4, FWU_UPDATE_TIMEOUT);
        break;
    case FWU_IMG_HEADER:
        printf (ID_ERROR_7, FWU_IMG_HEADER);
        break;
    case FWU_SGN_MISMATCH:
        printf (ID_ERROR_8, FWU_SGN_MISMATCH);
        break;
    case FWU_SKU_MISMATCH: 
        printf (ID_ERROR_9, FWU_SKU_MISMATCH);
        break;
    case FWU_VER_MISMATCH:
        printf (ID_ERROR_10, FWU_VER_MISMATCH);
        break;
    case FWU_USAGE_ERROR:
        printf (ID_ERROR_18, FWU_USAGE_ERROR);
        break;
    case FWU_USAGE_ERROR_B:
        printf (ID_ERROR_18B, FWU_USAGE_ERROR_B);
        break;
    case FWU_LAST_STATUS:
        printf (ID_ERROR_19, FWU_LAST_STATUS);
        break;
    case FWU_GET_VER_ERR:
        printf (ID_ERROR_24 , FWU_GET_VER_ERR);
        break;
    case FWU_AUDIT_POLICY_FAILURE:
        printf (ID_ERROR_25C, FWU_GENERAL);
        break;
    case FWU_ERROR_CREATING_FT:
        printf (ID_ERROR_25C, FWU_GENERAL);
        break;
    case FWU_SAL_NOTIFICATION_ERROR:
        printf (ID_ERROR_25A, FWU_GENERAL);
        break;
    case FWU_NO_UPDATE:
        printf (ID_ERROR_27, FWU_NO_UPDATE);
        break;
    case FWU_LOCAL_DIS:
        printf (ID_ERROR_29, FWU_LOCAL_DIS);
        break;
    case FWU_VERIFY_OEM_ID_ERR:
        printf (ID_ERROR_22 , FWU_VERIFY_OEM_ID_ERR);
        break;
    case FWU_INVALID_OEM_ID:
        printf (ID_ERROR_33, FWU_INVALID_OEM_ID);
        break;
    case FWU_FILE_OPEN:
        printf (ID_ERROR_34, FWU_FILE_OPEN);
        break;
    case FWU_IME_SMALL_BUFF:
        printf (ID_ERROR_36, FWU_IME_SMALL_BUFF);
        break;
    case FWU_IME_NO_DEVICE:
        printf (ID_ERROR_37, FWU_IME_NO_DEVICE);
        break;
    case FWU_IME_NOT_READY:
        printf (ID_ERROR_38, FWU_IME_NOT_READY);
        break;
    case FWU_IME_UN_SUP_MESS:
        printf (ID_ERROR_39, FWU_IME_UN_SUP_MESS);
        break;
    case FWU_INVALID_IMG_LENGTH:
        printf (ID_ERROR_40, FWU_INVALID_IMG_LENGTH);
        break;
    case FWU_GLBL_BUFF_UNAVAILABLE:
        printf (ID_ERROR_41, FWU_GLBL_BUFF_UNAVAILABLE);
        break;
    case FWU_INVALID_FW_PARAMS:
        printf (ID_ERROR_44, FWU_INVALID_FW_PARAMS);
        break;
    case FWU_FILE_WRITE:
        printf (ID_ERROR_55, FWU_FILE_WRITE);
        break;
    case FWU_DISPLAY_FW_VERSION:
        printf (ID_ERROR_56, FWU_DISPLAY_FW_VERSION);
        break;
    case FWU_IMAGE_UNDER_VCN:
        printf(ID_ERROR_57, FWU_IMAGE_UNDER_VCN);
        break;
    case FWU_IMAGE_VER_HIST_CHK_FAIL:
        printf (ID_ERROR_58, FWU_IMAGE_VER_HIST_CHK_FAIL);
        break;
    case FWU_DOWNGRADE_VETOED:
        printf (ID_ERROR_59, FWU_DOWNGRADE_VETOED);
        break;
    case FWU_FW_WRITE_FILE_FAIL:
        printf (ID_ERROR_60, FWU_FW_WRITE_FILE_FAIL);
        break;
    case FWU_FW_READ_FILE_FAIL:
        printf (ID_ERROR_61, FWU_FW_READ_FILE_FAIL);
        break;
    case 29:
        printf (ID_ERROR_62, FWU_FW_DELETE_FILE_FAIL);
        break;
    case FWU_PARTITION_LAYOUT_NOT_COMP:
        printf (ID_ERROR_63, FWU_PARTITION_LAYOUT_NOT_COMP);
        break;
    case FWU_DOWNGRADE_NOT_ALLOWED_DATA_MISMATCH:
        printf ("\nDowngrade is NOT permitted due to mismatched data format version.\n");
        printf (ID_ERROR_64, FWU_DOWNGRADE_NOT_ALLOWED_DATA_MISMATCH);
        break;
    case FWU_UPDATE_PASSWORD_NOT_MATCHED:
        printf (ID_ERROR_65, FWU_UPDATE_PASSWORD_NOT_MATCHED);
        break;
    case FWU_UPDATE_PASSWORD_EXCEED_MAXIMUM_RETRY:
        printf (ID_ERROR_66, FWU_UPDATE_PASSWORD_EXCEED_MAXIMUM_RETRY);
        printf (ID_INFO_16);
        break;
    case FWU_PID_NOT_EXPECTED:
        printf (ID_ERROR_72, FWU_PID_NOT_EXPECTED);
        break;
    case FWU_FILE_ALREADY_EXISTS:
        printf ("Error %d: File already exists\n", FWU_FILE_ALREADY_EXISTS);
        break;
    case FWU_FILE_INVALID:
        printf ("Error %d: Invalid File\n", FWU_FILE_INVALID);
        break;
    case FWU_SAVE_RESTORE_POINT_ERROR:
        printf ("\nError %d: Restore Point Image Failure\n", FWU_SAVE_RESTORE_POINT_ERROR);
        break;
    case FWU_GET_BLIST_ERROR:
        printf ("\nError %d: Get Black List Failure\n" , FWU_GET_BLIST_ERROR);
        break;
    case FWU_GET_PATTRIB_ERROR:
        printf ("\nError %d: Get Partition Attribute Failure\n" , FWU_GET_PATTRIB_ERROR);
        break;
    case FWU_GET_UPD_INFO_STATUS:
        printf ("\nError %d: Get Update Info Status Failure\n" , FWU_GET_UPD_INFO_STATUS);
        break;
    case FWU_BUFFER_COPY_FAILED:
        printf ("\nError %d:Buffer Copy Failure\n" , FWU_BUFFER_COPY_FAILED);
        break;
    default:
        printf (ID_ERROR_25, FWU_GENERAL);
        break;
    }
}



//sample code
void usage(void)
{
    printf(" -f <name>	Input file to perform Fwupdate.\n");
    printf(" -h		Display Usage options.\n");
    printf(" Note: Please run the Application with administrative privileges.\n");
    exit (0);
}

int main(int argc, char *argv[])
{
    //char* ImageFile;

    printf("Program name: %s\n\n", argv[0]);

    while ((argc > 1) && (argv[1][0] == '-'))
    {
        switch (argv[1][1])
        {
        case 'f':
            printf("%s\n",&argv[1][2]);
            printf("Usage option: %s\n", &argv[1][1]);
            printf("sub param: %s\n", &argv[2][0]);
            PerformUpdate(&argv[2][0]);
            break;
        case 'h':
            usage();
            break;
		case 's':
			printf("%s\n",&argv[3][0]);
            printf("Usage option: %s\n", &argv[1][1]);
            printf("sub param: %s\n", &argv[3][1]);
            PerformUpdate(&argv[2][0]);
			break;
        default:
            printf("Invalid Argument: %s\n", argv[1]);
            usage();
        }
        ++argv;
        --argc;
    }
    return (0);

}

// This fucntion prints the progress bar line during hte fw update process. 
static UINT32 ProgressDot(int timer30s)
{
    // new code
    INT32 i = 0;
    char string[3][80] = {
        "                       Do not Interrupt", 
        "                       Do not Interrupt", 
        "                       Do not Interrupt"};

    for (i = 0; i < 3; i++)
    {

        printf ("Progress Dot %s \r", string[i]);
        timer30s++; 
    }
    return 0;
} 

// end sample code

int PerformUpdate(char* ImageBuffer)
{
    UINT32            Status;
    UINT32            ImageLength = 0;
    BOOLEAN           bAllowSV;
    BOOLEAN           bUsePassword;
    BOOLEAN           bPid;
    BOOLEAN           bF;
    char              *Password = NULL;
    //CHAR              Password[9];
    UINT32            FWUpdateStatus;
    DWORD             loops = 500;
    BOOLEAN           done = FALSE;
    UINT32            lastStatus = 0;
    UINT32            platCheck = 0;
    FWVersion         fwVersion;
    INT32             platCheckReturn = 0; 
    UINT32            CheckPolicyStatus = 0;
    UPDATE_TYPE       Upd_Type;
    VersionLib        ver;
    UINT32            index = 0;
    UINT32            status;
    UINT32            UpdateStatus = 0;
    UINT32            TotalStages = 0;
    UINT32            PercentWritten = 0;  
    char              symbol;
    UINT32            lastResetType;
    UPDATE_FLAGS_LIB  update_flags;
    UINT16            interfaces;
    int               timer30s = 0;
    unsigned int       indexMod;
    int                percentage0s = 0;
    int                percentdiff = 0;
    UINT32             ComparePartID = 0;
    UINT32             hexValueInstId = 0;
    IPU_UPDATED_INFO   IpuUpdatedInfo;
    UINT32             PartId = 0;
    UINT32             g_fwuError;
    FWU_GET_IPU_PT_ATTRB_MSG_REPLY FwuGetIpuAttrbMsgInfo;
    bool               found = false;
    UINT32             i, j = 0;
    UINT16 major = 0;
    UINT16 minor = 0;
    UINT16 hotfix = 0;
    UINT16 build = 0;
    UINT32 itr = 0;
    UINT32               RuleData;
	UINT32 Fwtype = 0;
	UINT32 sku =0;
	char OEMID[37] = {0};

    //Zero out the update flag structure
    memset(&update_flags,0,sizeof(UPDATE_FLAGS_LIB));

    printf ("\nIntel (R) Firmware Update Utility Sample Application \n");

		GetFwType(&Fwtype);
	if (Fwtype) 
		printf("\n FW Type: Corporate \n");
	else 
		printf("\n FW Type: Consumer \n");

	GetOemID(OEMID, 37);
	//cout << OEMID;
	printf("\n OEM ID : %s \n", OEMID);
	
	GetPchSKU(&sku);
	//TextOutput(MESSAGE_NORMAL, "\n possible options: H == 0, LP == 1. FwType is %d\n", FwType)
	if (sku) 
		printf("\n PCH Sku : LP \n"); 
	else 
		printf("\n PCH Sku : H \n");
	printf("\n");
    // sample code to check the file type
    if(CheckFileExt(ImageBuffer))
    {
        if((g_fwuError = GetFwVersion(ImageBuffer,&major,&minor,&hotfix,&build)))
        {
            DisplayTextForReturnErrorCode(g_fwuError);
            printf("\nSTATUS: display FW version failed.\n");
        }
        else
        {
            printf("FW Version: %i.%i.%i.%i\n",major,minor,hotfix,build);
            g_fwuError = FWU_ERROR_SUCCESS;
        }
    }
    else
    {
        DisplayTextForReturnErrorCode(FWU_FILE_INVALID);
    }

    // end of sample code to check the file type

    //
    // Get the current status of the ME FWUpdate Client - verifies if the client is 
    // installed
    //
    if (GetLastStatus(&lastStatus)) {
        printf (ID_ERROR_19, FWU_LAST_STATUS);
        return FWU_ERROR_SUCCESS;
    }

    //
    // Is there a pending reset?
    //
    if (GetLastUpdateResetType (&lastResetType)) { 
        printf (ID_ERROR_19, FWU_LAST_STATUS);
        return FWU_ERROR_SUCCESS;
    }

    if (STATUS_UPDATE_HOST_RESET_REQUIRED == lastStatus) {
        printf (ID_ERROR_51, FWU_REBOOT_NEEDED);
        return FWU_ERROR_SUCCESS;
    }

    switch (lastResetType) {
    case MFT_PART_INFO_EXT_UPDATE_ACTION_HOST_RESET:

    case MFT_PART_INFO_EXT_UPDATE_ACTION_GLOBAL_RESET:
        printf (ID_ERROR_51, FWU_REBOOT_NEEDED);
        return FWU_ERROR_SUCCESS;
        break;
    default:
        break;
    }

    printf (ID_INFO_3);

    //
    // Is update supported? 
    //
    if (GetInterfaces (&interfaces)) {
        printf (ID_ERROR_19, FWU_LAST_STATUS);
        return FWU_ERROR_SUCCESS;
    }

    switch (interfaces) {
    case FW_UPDATE_DISABLED:
        printf ("Local FWUpdate is Disabled\n"); 
        return FWU_ERROR_SUCCESS;
    case FW_UPDATE_PASSWORD_PROTECTED:
        printf ("Local FWUpdate is Password Protected\n"); 
        break;
    case FW_UPDATE_ENABLED:
        break;
    default:
        break;
    }


    printf ("Checking firmware parameters...\n");

    CheckPolicyStatus = CheckPolicyBuffer((char *)ImageBuffer, (INT32)ImageLength, (INT32)bAllowSV, &Upd_Type, &ver);		   

    switch (Upd_Type) {
    case DOWNGRADE_SUCCESS:
    case SAMEVERSION_SUCCESS:
    case UPGRADE_SUCCESS:
        break;

    case DOWNGRADE_FAILURE:
        printf ("FW Update downgrade not allowed\n");
        return FWU_ERROR_SUCCESS;
        break;
    case SAMEVERSION_FAILURE:
        printf ("FW Update same version not allowed, specify /s on command line\n");
        return FWU_ERROR_SUCCESS;

    default:
        break;
    }

    //
    // Password hack for testing - replace with OEM version if password required
    // 
    /*if (!bUsePassword) {
        memset (Password,0, sizeof (Password));
    }*/

    FWUpdateStatus = FwUpdateFull(ImageBuffer,Password,0,FWU_ENV_MANUFACTURING,mOemId, update_flags,&DisplaySendStatus);

    if (FWU_ERROR_SUCCESS != FWUpdateStatus) {
        DisplayTextForReturnErrorCode(FWUpdateStatus);
        return FWU_ERROR_SUCCESS;
    }

    // 
    // Image downloaded to FW Update Client
    // Now query the status of the update being applied
    //

    printf ("\nFW Update:  [  0 %% ]\r");
    index = 0;

    // 
    // Loop through Polling for Fw Update Stages
    //
    ProgressDot(timer30s);
    do {
        //We mod4 the index to determine which ascii animation frame to display for this iteration.
        indexMod = (++index % 4);
        //symbol = (++index % 2 == 0)?'|': '-';
        switch(indexMod)
            //loop through (|) (/) (-) (\) (|) (/) ...
        {
        case CMD_LINE_STATUS_UPDATE_1: symbol =  '|';  break;
        case CMD_LINE_STATUS_UPDATE_2: symbol =  '/';  break;
        case CMD_LINE_STATUS_UPDATE_3: symbol =  '-';  break;
        case CMD_LINE_STATUS_UPDATE_4: symbol =  '\\'; break;
        }
        Status = FWUpdate_QueryStatus_Get_Response(&UpdateStatus, &TotalStages, &PercentWritten, &lastStatus, &lastResetType);
        if(PercentWritten > 100)
        {
            break;
        }
        if (Status == FWU_ERROR_SUCCESS)
        {
            printf ("FW Update:  [ %d%% (%c)]\r" ,PercentWritten, symbol);
        } else if (lastStatus != STATUS_UPDATE_NOT_READY)
        {
            printf ("\n");
            break; //break out of the loop
        }
        //BS->Stall(100000); // Wait 1 sec before polling again
        Sleep(250);
        if(timer30s >= 30000) 
        {
            percentdiff = PercentWritten - percentage0s;
            if(percentdiff < 1)
            {
                //TODO: Add timeout when add cmdline option
                //Status = FWU_UPDATE_TIMEOUT;
            } else 
            {
                percentage0s = PercentWritten;
                timer30s = 0;
            }
        } else 
        {
            timer30s+=250;
        }
    } while ((PercentWritten != 100) && (Status == FWU_ERROR_SUCCESS)); 



    switch (Status) {
    case FWU_NO_MEMORY:
    case FWU_IME_NO_DEVICE:
        printf (ID_ERROR_68, FWU_UPDATE_POLLING_FAILED);
        return FWU_ERROR_SUCCESS;
    case FWU_IME_NOT_READY:
        DisplayTextForReturnErrorCode(status);
        return FWU_ERROR_SUCCESS;
    case FWU_ERROR_FW:
        printf (ID_ERROR_69, FWU_ERROR_FW, UpdateStatus);
        return FWU_ERROR_SUCCESS;
    default:
        break;
    }

    switch (lastStatus) {
    case STATUS_SUCCESS:
        switch (lastResetType) {

        case MFT_PART_INFO_EXT_UPDATE_ACTION_NONE:

        case MFT_PART_INFO_EXT_UPDATE_ACTION_CSE_RESET:
            printf ("\nFW Update is completed successfully.\n");
            break;
        case MFT_PART_INFO_EXT_UPDATE_ACTION_HOST_RESET:

        case MFT_PART_INFO_EXT_UPDATE_ACTION_GLOBAL_RESET:
            printf ("\nFW Update is complete and a reboot will run the new FW.\n");
            break;
        default:
            printf ("\nFW Update is complete and a reboot will run the new FW.\n");
            break;
        }
        break;
    case STATUS_UPDATE_IMAGE_INVALID:
        DisplayTextForReturnErrorCode(FWU_IMG_HEADER);
        break;
    case STATUS_UPDATE_INTEGRITY_FAILURE:
        DisplayTextForReturnErrorCode(FWU_SGN_MISMATCH);
        break;
    case STATUS_UPDATE_SKU_MISMATCH:
        DisplayTextForReturnErrorCode(FWU_SKU_MISMATCH);
        break;
    case STATUS_UPDATE_FW_VERSION_MISMATCH:
        DisplayTextForReturnErrorCode(FWU_VER_MISMATCH);
        break;
    case STATUS_UPDATE_GENERAL_FAILURE:
        DisplayTextForReturnErrorCode(FWU_GENERAL);
        break;
    case STATUS_UPDATE_OUT_OF_RESOURCES:
        DisplayTextForReturnErrorCode(FWU_NO_MEMORY);
        break;
    case STATUS_UPDATE_AUDIT_POLICY_FAILURE:
        DisplayTextForReturnErrorCode(FWU_AUDIT_POLICY_FAILURE);
        break;
    case STATUS_UPDATE_ERROR_CREATING_FT:
        DisplayTextForReturnErrorCode(FWU_ERROR_CREATING_FT);
        break;
    case STATUS_UPDATE_SAL_NOTIFICATION_ERROR:
        DisplayTextForReturnErrorCode(FWU_SAL_NOTIFICATION_ERROR);
        break;
    case STATUS_INVALID_OEM_ID:
        DisplayTextForReturnErrorCode(FWU_INVALID_OEM_ID);
        break;
    case STATUS_DOWNGRADE_NOT_ALLOWED_VCN_RESTRICTION:
        DisplayTextForReturnErrorCode(FWU_IMAGE_UNDER_VCN);
        break; 
    case STATUS_DOWNGRADE_NOT_ALLOWED_SVN_RESTRICTION:
        printf("\nFW downgrade is not allowed due to SVN restriction.\n");
        break;
    case STATUS_UPDATE_IMAGE_BLACKLISTED:
        printf("\nFW Update/downgrade is not allowed to the supplied FW image.\n");
        break;
    default:
        printf("lastStatus = %d\n",lastStatus);
        DisplayTextForReturnErrorCode(FWU_GENERAL);
        break;
    }

    return FWU_ERROR_SUCCESS;
}

